<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormModifyUrl()
  ===================================================*/

  function ShowFormModifyUrl() {

    // vars global configuration
    global $dbConn, $category_separator, $theme_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $link_id, $title, $url, $description, $category, $contact_name, $email,
             $custom_field_form, $add_cat1, $add_cat2;

    $title = $_POST['title'];

    if (empty($link_id))
      $link_id = $id;

    $title        = stripslashes($title);
    $url          = stripslashes($url);
    $description  = stripslashes($description);
    $contact_name = stripslashes($contact_name);
    $email        = stripslashes($email);

    // check for invalid link_id
    $query        = "select link_id from idx_link where link_id = '$link_id'";
    $result       = $dbConn->Execute($query);

    if ($result)
      $lid = $result->Fields('link_id');

    if ($lid == "") {
      $error_msg = $msg['10148'];
      DisplayTemplate($theme_path . "modify_select.html", "\$error_msg");
      RunPostFilter(__FILE__);
    }

    // generate custom field
    $links_obj                                    = new clsLink;
    $links_obj->table_name                        = "idx_link";
    $links_obj->category_table_name               = "idx_category";
    $links_obj->autogenerate_form_text            = $msg["00001"];
    $links_obj->autogenerate_form_textarea        = $msg["00002"];
    $links_obj->autogenerate_form_image           = $msg["00004"];
    $links_obj->autogenerate_form_file            = $msg["00006"];
    $links_obj->autogenerate_form_select          = $msg["00007"];
    $links_obj->autogenerate_form_multiselect     = $msg["00008"];
    $links_obj->autogenerate_form_checkbox        = $msg["00009"];
    $links_obj->autogenerate_form_radio           = $msg["00010"];
    $links_obj->autogenerate_form_date            = $msg["00011"];
    $links_obj->autogenerate_form_datetime        = $msg["00012"];
    $links_obj->autogenerate_form_template        = $theme_path . "custom_field_form_rows.html";
    $links_obj->template_file                     = $theme_path . "cp/link_modify_form.html";
    $links_obj->Modify("display_form", $link_id);
  }


  /*===================================================
    ProcessFormModifyUrl()
  ===================================================*/

  function ProcessFormModifyUrl() {

    // vars global configuration
    global $dbConn, $site_url, $theme_path, $category_separator, $email_address;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $link_id, $cat, $title, $url, $description, $contact_name, $email, $bid, $category, $password,
             $reciprocal_check, $reciprocal_url, $add_cat1, $add_cat2;

    $title = $_POST['title'];

    if (empty($link_id))
      $link_id = $id;

    // verify input

    if (empty($title))
      $error_msg = $msg["10121"];
    elseif (empty($url) || $url == 'http://')
      $error_msg = $msg["10122"];
    elseif (empty($description))
      $error_msg = $msg["10123"];
    elseif (empty($contact_name))
      $error_msg = $msg["10124"];
    elseif (empty($email))
      $error_msg = $msg["10125"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["10126"];
    elseif (!empty($bid) && !Ismoney($bid))
      $error_msg = $msg["10127"];
    elseif ($reciprocal_check) {
      if (!IsValidReciprocalURL($url, $reciprocal_url)) {
        $error_msg = $msg['10145'];
      }
    }
    
    $query    = "select password from idx_link where link_id = '$link_id'";
    $result   = $dbConn->Execute($query);
    $password = $result->Fields('password');

    if (empty($error_msg)) {

      // get field
      $links_obj = new clsLink;
      $links_obj->table_name          = "idx_link";
      $links_obj->category_table_name = "idx_category";
      $links_obj->editor_table_name   = "idx_editor";
      $links_obj->user_table_name     = "idx_users";
      $modify_result                  = $links_obj->Modify("process_form", $link_id);

      $category_obj = new clsCategory;
      $category_obj->table_name = "idx_category";
      $category_obj->separator  = $category_separator;
      $category                 = $category_obj->GetCategoryPath($cat);

      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";

      $title        = stripslashes($title);
      $description  = stripslashes($description);
      $contact_name = stripslashes($contact_name);

      // successfully modified

      if ($modify_result == 0) {

        // send email submitter

        $body = EvalTemplate($theme_path . "mail/modify_ok.mail", $links_obj->email_template_fields);
        $from = $email_address;
        @mail($email, $msg["10131"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

        // send email to all editors

        $emails   = $links_obj->GetEditorEmail($cat);
        $emails[] = $email_address;

        while (list(, $v) = @each($emails)) {
          $body = EvalTemplate($theme_path . "mail/add_ok_editor.mail", $links_obj->email_template_fields);
          $from = $email_address;
          @mail($v, $msg["10133"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");
        }

        DisplayTemplate($theme_path . "cp/link_modify_ok.html");
      }

      // pending

      elseif ($modify_result == 1) {

        // send email submitter
        $body = EvalTemplate($theme_path . "mail/add_pending.mail", $links_obj->email_template_fields);
        $from = $email_address;
        @mail($email, $msg["10135"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

        // send email to all editors

        $emails   = $links_obj->GetEditorEmail($cat);
        $emails[] = $email_address;

        while (list(, $v) = @each($emails)) {
          $body = EvalTemplate($theme_path . "mail/add_pending_editor.mail", $links_obj->email_template_fields . ",\$site_url");
          $from = $email_address;
          @mail($v, $msg["10137"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");
        }

        DisplayTemplate($theme_path . "cp/link_modify_pending.html");
      }
      elseif ($modify_result == 2) {
        $error_msg = $msg["10129"];
        ShowFormModifyUrl();
      }
    }
    else
      ShowFormModifyUrl();
    }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormModifyUrl();
  }
  elseif ($pflag == 'modify') {
    ProcessFormModifyUrl();
  }

  RunPostFilter(__FILE__);

?>